# app/models/products.py
from webapp import *



class Article(db.Model):
    __tablename__="_article"
    id=db.Column(db.Integer, primary_key=True)
    code=db.Column(db.String(30), default="")
    nom=db.Column(db.String(256), default="")
    unite=db.Column(db.String(20), default="")
    prix_achat=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    prix_vente=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    stock=db.Column(db.Integer, default=0)
    @property
    def prix_achat_html(self):
        return str(self.prix_achat)
    @property
    def prix_vente_html(self):
        return str(self.prix_vente)
    @property
    def full_name(self):
        return self.code+" "+self.nom

class HistoriquePrix(db.Model):
    __tablename__="_historique_prix"
    id=db.Column(db.Integer, primary_key=True)
    date=db.Column(db.Date, default=db.func.current_timestamp())
    article_id=db.Column(db.Integer, db.ForeignKey('_article.id'))
    article=relationship("Article", backref='historque_prix')
    prix_achat=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    prix_vente=db.Column(db.Numeric(precision=20, scale=2),default=Decimal(0))
    motif=db.Column(db.String(30), default="AJOUT") #MODIFICATION
    session=db.Column(db.String(100), default="admin")





class ArticleForm(FlaskForm):
    code = StringField('Code', validators=[DataRequired(), Length(max=40)],render_kw={"autocomplete":"off"})
    nom = StringField('Nom', validators=[DataRequired(),Length(max=200)],render_kw={"autocomplete":"off"})
    unite = StringField('Unité', validators=[Length(max=20)])
    prix_achat = DecimalField('Prix d\'achat', places=2, default=Decimal(0),validators=[DataRequired()])
    prix_vente = DecimalField('Prix de vente', places=2, default=Decimal(0),validators=[DataRequired()])
    submit = SubmitField('Enregistrer')



    